import json
 
def generate_manifest(
    labels: list,
    dataset_bucket: str,
    dataset_namespace: str,
    record_bucket: str,
    record_namespace: str,
    record_path: str,
    output_path: str,
    prefix: str
):
    """
    Generate a JSONL file with a single JSON object for single-label annotation format.
    """
    json_obj = {
        "id": "dummy",
        "compartmentId": "dummy",
        "displayName": "training_data",
        "labelsSet": [{"name": label} for label in labels],
        "annotationFormat": "SINGLE_LABEL",
        "datasetSourceDetails": {
            "namespace": dataset_namespace,
            "bucket": dataset_bucket,
            "prefix": prefix
        },
        "datasetFormatDetails": {
            "formatType": "DOCUMENT"
        },
        "recordFiles": [
            {
                "namespace": record_namespace,
                "bucket": record_bucket,
                "path": record_path
            }
        ]
    }
 
    with open(output_path, "w") as f:
        f.write(json.dumps(json_obj) + "\n")
     
    print(f"JSONL file written to {output_path} with {len(labels)} labels.")
 
## Test Example
labels = ["label1", "label2"] # Be careful, it's case sensitive

generate_manifest(
    labels=labels,
    dataset_bucket="raushan_bucket",
    dataset_namespace="axylfvgphoea",
    record_bucket="raushan_bucket",
    record_namespace="axylfvgphoea",
    record_path="test_ls_integration/records_converted_dc.json",
    output_path="manifest_converted_dc.jsonl",
    prefix="test_ls_integration/"  #prefix always ends with /
)