import os
import oci
import uuid
import base64
from dotenv import load_dotenv

# Load variables from .env into environment
load_dotenv()

# Setup basic variables
# Auth Config
CONFIG_PROFILE = os.getenv("CONFIG_PROFILE")
config = oci.config.from_file('~/.oci/config', CONFIG_PROFILE)
token_file = config['security_token_file']
token = None

with open(token_file, 'r') as f:
    token = f.read()

private_key = oci.signer.load_private_key_from_file(config['key_file'])
signer = oci.auth.signers.SecurityTokenSigner(token, private_key)

# Compartment where processor job will be created
COMPARTMENT_ID = os.getenv("COMPARTMENT_ID")
# Service endpoint
endpoint = os.getenv("SERVICE_ENDPOINT")
aiservicedocument_client = oci.ai_document.AIServiceDocumentClient(config=config, service_endpoint=endpoint, signer=signer)
# Generate Searchable PDF Feature
text_detection_feature_searchable_pdf = oci.ai_document.models.DocumentTextExtractionFeature()
text_detection_feature_searchable_pdf.generate_searchable_pdf = False

def get_ocr_output(image_path):
    #sample document
    text_detection_sample_string = None
    with open(image_path, "rb") as document_file:
        text_detection_sample_string = base64.b64encode(document_file.read()).decode('utf-8')

    document_details = oci.ai_document.models.AnalyzeDocumentDetails(features=[text_detection_feature_searchable_pdf],
                                                                    document=oci.ai_document.models.InlineDocumentDetails(
                                                                        data=text_detection_sample_string),
                                                                    compartment_id=COMPARTMENT_ID
                                                                    )
    response = aiservicedocument_client.analyze_document(analyze_document_details=document_details)

    #print("Calling sync api with text_detection_demo.jpg:", response.data)
    return response.data
